<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive.
 *
 * Override this template by copying it to yourtheme/woocommerce/archive-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates

 */



if (!defined('ABSPATH')) { exit; } // Exit if accessed directly

global $woocommerce;

$cart_url = $woocommerce->cart->get_cart_url();
get_header('shop'); ?>



<div class="container">
<?php 
   //global  $woocommerce;
  
?>
<style type="text/css">#sidebar { display: none; } .woocommerce-pagination { display: none; }</style>



	<?php

		/**
		 * woocommerce_before_main_content hook
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 */

		do_action('woocommerce_before_main_content');

	?>



		<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>


			<div class="archive_header_left">
				<h1 class="page-title"><?php woocommerce_page_title(); ?></h1>
				<?php do_action( 'woocommerce_before_shop_loop' ); ?>
			</div>



		<?php endif; ?>



		<?php do_action( 'woocommerce_archive_description' ); ?>



		

		<?php if ( have_posts() ) : ?>

			<div class="clear"></div>
		</div>

</div>
</div>


									
					<div id="shop_cont">
						<div class="container">
						<div id="prods">



				<?php woocommerce_product_subcategories(); ?>


				<?php

				global $wp_query;


				$max_pages = $wp_query->max_num_pages;
				?>

				<?php $x = 1; while ( have_posts() ) : the_post(); ?>

						
							<div class="item prod_box <?php if ($x%3==0) echo 'last'; ?>">
								<div class="prod_box_img">
									<?php if(get_post_meta( get_the_ID(), 'page_featured_type', true ) == 'youtube') { ?>
										<iframe width="560" height="315" src="http://www.youtube.com/embed/<?php echo get_post_meta( get_the_ID(), 'page_video_id', true ); ?>" frameborder="0" allowfullscreen></iframe>
									<?php } elseif(get_post_meta( get_the_ID(), 'page_featured_type', true ) == 'vimeo') { ?>
										<iframe src="http://player.vimeo.com/video/<?php echo get_post_meta( get_the_ID(), 'page_video_id', true ); ?>?title=0&amp;byline=0&amp;portrait=0&amp;color=3399ff" width="500" height="338" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
									<?php } else { ?>
										<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('shop_archive_img'); ?></a>
									</div> <!-- //prod_box_img -->
										<?php woocommerce_get_template_part( 'content', 'product-home-inside' ); ?>						
													
									<?php } ?>												
								
								
										
										
										
							
								
								
								
							</div> <!-- //prod_box -->                               				
				

				<?php $x++; endwhile; // end of the loop. ?>
							</div><!--//prods-->
						</div><!--//container-->
					</div><!--//stalac_cont-->
					
				
		

			<?php

				/**

				 * woocommerce_after_shop_loop hook

				 *

				 * @hooked woocommerce_pagination - 10

				 */

				do_action( 'woocommerce_after_shop_loop' );

			?>



		<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>



			<?php woocommerce_get_template( 'loop/no-products-found.php' ); ?>



		<?php endif; ?>

		<div class="clear"></div>

			<div class="load_more_cont">
				<div align="center"><div class="load_more_text">

				<?php

				ob_start();
				//next_posts_link('<img src="' . get_bloginfo('stylesheet_directory') . '/images/loading-button.png" />');
				next_posts_link('LOAD MORE');
				$buffer = ob_get_contents();
				ob_end_clean();
				if(!empty($buffer)) echo $buffer;
				?>

				</div></div>
			</div><!--//load_more_cont-->     					

			<?php
			global $wp_query;
			//echo '**' . $wp_query->max_num_pages . '**';	
			$max_pages = $wp_query->max_num_pages;
			?>			
			<div id="max_pages_id" style="display: none;"><?php echo ceil($wp_query->found_posts / 9); //echo $max_pages-1; ?></div>					
			
			<?php wp_reset_query(); ?>

	<?php

		/**

		 * woocommerce_after_main_content hook

		 *

		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)

		 */

		do_action('woocommerce_after_main_content');

	?>



	<?php

		/**

		 * woocommerce_sidebar hook

		 *

		 * @hooked woocommerce_get_sidebar - 10

		 */

		//do_action('woocommerce_sidebar');

	?>
<script type="text/javascript">
$(document).ready(
function($){

var curPage = 1;
var pagesNum = $("#max_pages_id").html();   // Number of pages	

if(pagesNum == 1)
	$('.load_more_text a').css('display','none');	

  $('#prods').infinitescroll({
 
    navSelector  : "div.load_more_text",            
		   // selector for the paged navigation (it will be hidden)
    nextSelector : "div.load_more_text a:first",    
		   // selector for the NEXT link (to page 2)
    itemSelector : "#prods .prod_box",
		   // selector for all items you'll retrieve
	behavior: 'twitter',
    maxPage: <?php echo $max_pages; ?>
  },function(arrayOfNewElems){
    
      //$('.home_post_cont img').hover_caption();
      $('.load_more_text a').css('visibility','visible');

            curPage++;
//            alert(curPage + '**' + pagesNum);
			 
            if(curPage == pagesNum) {

                //$(window).unbind('.infscr');
                $('.load_more_text a').css('display','none');

            } else { $('#infscr-loading').remove(); }  		      
 
     // optional callback when new content is successfully loaded in.
 
     // keyword `this` will refer to the new DOM content that was just added.
     // as of 1.5, `this` matches the element you called the plugin on (e.g. #content)
     //                   all the new elements that were found are passed in as an array
 

  });  
}  
);
</script>	


<?php get_footer('shop'); ?>





