<?php
/**
 * Cart Page
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.8
 */
    
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


?>


<!-- Cart container -->
                <section class="cart">



                    <div class="container">
                        
                        <?php
                            wc_print_notices();
                        ?>
                        <div class="row">

                            <div class="span9">
                                
                                <!-- Cart -->
                                <div class="box">
                                    
                                    
                                    
                                     <?php do_action( 'woocommerce_before_cart' ); ?>
                                    <form action="<?php echo esc_url( WC()->cart->get_cart_url() ); ?>" method="post">
                                        
                                        <div class="box-header">
                                            <h3><?php echo __('Shopping cart', DOMAIN); ?></h3>
                                            <h5><?php echo sprintf(__('You currently have %s item(s) in your cart', DOMAIN),'<strong>'.WC()->cart->cart_contents_count.'</strong>');?></h5>
                                        </div>

                                        <div class="box-content">
                                            <div class="cart-items">
                                                
                                                       

                                                        

                                                        <?php do_action( 'woocommerce_before_cart_table' ); ?>

                                                        <table class="shop_table cart styled-table" cellspacing="0">
                                                                <thead>
                                                                        <tr>
                                                                                
                                                                                <th class="product-thumbnail text-left"><?php _e( 'Product', 'woocommerce' ); ?></th>
                                                                                <th class="product-name text-left"></th>
                                                                                <th class="product-remove text-right">&nbsp;</th>
                                                                                <th class="product-price text-right"><?php _e( 'Price', 'woocommerce' ); ?></th>
                                                                                <th class="product-quantity text-right"><?php _e( 'Quantity', 'woocommerce' ); ?></th>
                                                                                <th class="product-subtotal text-right"><?php _e( 'Total', 'woocommerce' ); ?></th>
                                                                        </tr>
                                                                </thead>
                                                                <tbody>
                                                                        <?php do_action( 'woocommerce_before_cart_contents' ); ?>

                                                                        <?php
                                                                            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                                                                                    $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                                                                                    $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

                                                                                    if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
                                                                                            ?>
                                                                                                <tr class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
                                                                                                        

                                                                                                        <!-- The thumbnail -->
                                                                                                        <td data-title="<?php _e( 'Thumbnail', 'woocommerce' ); ?>" class="text-left product-thumbnail">
                                                                                                            <div class="image ">
                                                                                                                <?php
                                                                                                                        $thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

                                                                                                                        if ( ! $_product->is_visible() )
                                                                                                                                echo $thumbnail;
                                                                                                                        else
                                                                                                                                printf( '<a href="%s">%s</a>', $_product->get_permalink( $cart_item ), $thumbnail );
                                                                                                                ?>
                                                                                                            </div>
                                                                                                        </td>

                                                                                                        <!-- Product Name -->
                                                                                                        <td data-title="<?php _e( 'Product', 'woocommerce' ); ?>" class="product-name text-left">
                                                                                                                <?php
                                                                                                                                if ( ! $_product->is_visible() )
                                                                                                                                        echo apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key ) . '&nbsp;';
                                                                                                                                else
                                                                                                                                        echo apply_filters( 'woocommerce_cart_item_name', sprintf( '<a href="%s">%s </a>', $_product->get_permalink( $cart_item ), $_product->get_title() ), $cart_item, $cart_item_key );

                                                                                                                                // Meta data
                                                                                                                                echo WC()->cart->get_item_data( $cart_item );

                                                                                                                // Backorder notification
                                                                                                                if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) )
                                                                                                                        echo '<p class="backorder_notification">' . __( 'Available on backorder', 'woocommerce' ) . '</p>';
                                                                                                                        ?>
                                                                                                        </td>
                                                                                                        
                                                                                                        <!-- Remove from cart link -->
                                                                                                        <td data-title="<?php _e( 'Remove', 'woocommerce' ); ?>" class="product-remove text-right">                                                                                                                
                                                                                                                <?php
                                                                                                                    echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf( '<a href="%s" class="remove" title="%s"><i class="icon-trash icon-large"></i></a>', esc_url( WC()->cart->get_remove_url( $cart_item_key ) ), __( 'Remove this item', 'woocommerce' ) ), $cart_item_key );
                                                                                                                ?>
                                                                                                        </td>

                                                                                                        <!-- Product price -->
                                                                                                        <td data-title="<?php _e( 'Price', 'woocommerce' ); ?>" class="product-price text-right">
                                                                                                                <?php
                                                                                                                        echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
                                                                                                                ?>
                                                                                                        </td>

                                                                                                        <!-- Quantity inputs -->
                                                                                                        <td data-title="<?php _e( 'Quantity', 'woocommerce' ); ?>" class="product-quantity text-right">
                                                                                                                <?php
                                                                                                                        if ( $_product->is_sold_individually() ) {
                                                                                                                                $product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
                                                                                                                        } else {
                                                                                                                                $product_quantity = woocommerce_quantity_input( array(
                                                                                                                                        'input_name'  => "cart[{$cart_item_key}][qty]",
                                                                                                                                        'input_value' => $cart_item['quantity'],
                                                                                                                                        'max_value'   => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
                                                                                                                                        'min_value'   => '0'
                                                                                                                                ), $_product, false );
                                                                                                                        }

                                                                                                                        echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key );
                                                                                                                ?>
                                                                                                        </td>

                                                                                                        <!-- Product subtotal -->
                                                                                                        <td data-title="<?php _e( 'Total', 'woocommerce' ); ?>" class="product-subtotal text-right">
                                                                                                                <?php
                                                                                                                        echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
                                                                                                                ?>
                                                                                                        </td>
                                                                                                </tr>
                                                                                                <?php
                                                                                        }
                                                                                }
                                                                   

                                                                            do_action( 'woocommerce_cart_contents' );
                                                                        ?>
                                                                        

                                                                        <?php do_action( 'woocommerce_after_cart_contents' ); ?>
                                                                </tbody>
                                                        </table>

                                                        <?php do_action( 'woocommerce_after_cart_table' ); ?>

                                                        
                                                
                                            </div>
                                        </div>

                                        <div class="box-footer actions">
                                            

                

                                        <div class="pull-left">
	
                                            <input type="button" onclick="location.href='<?php echo get_permalink(woocommerce_get_page_id('shop')); ?>';" class="btn" value="<?php echo esc_attr(__('Continue shopping', DOMAIN)); ?>" />
                                        </div>

                                        <div class="pull-right">
                                                                                        
                                            <input type="submit" class="button btn  mm20" name="update_cart" value="<?php _e( 'Update Cart', 'woocommerce' ); ?>" /> 
                                            <input type="submit" class="checkout-button button alt wc-forward btn btn-primary" name="proceed" value="<?php _e( 'Proceed to Checkout', 'woocommerce' ); ?>" />
                                    
                                        </div>
                                       
                                        <?php do_action( 'woocommerce_cart_actions' ); ?>
                                        <?php wp_nonce_field( 'woocommerce-cart' ) ?>
		

                                        </div>
                                    </form>			
                                </div>
                                <!-- End Cart -->

                            
                                
                            </div>

                            <div class="span3">
                                <div class="cart-collaterals">
                                        <?php woocommerce_cart_totals();?>
                                        <?php/*
                                        <?php do_action( 'woocommerce_cart_collaterals' ); ?>
                                        */?>
                                </div>
                             
                                
                                <?php if ( WC()->cart->coupons_enabled() ) { ?>
                                <div class="coupon">
                                    <div class="box">
                                        <div class="hgroup title">
                                            <h3><?php _e( 'Coupon', 'woocommerce' ); ?></h3>
                                            <h5><?php echo __('Enter your coupon here to redeem', DOMAIN); ?></h5>
                                        </div>
                                        
                                        
                                        
                                        <form action="<?php echo esc_url( WC()->cart->get_cart_url() ); ?>" method="post">
                                   
                                           <label for="coupon_code"><?php _e( 'Coupon', 'woocommerce' ); ?>:</label> 
                                           <div class="input-append">
                                            <input name="coupon_code" class="input-text" type="text" id="coupon_code" value="" /> 
                                            <input type="submit" class="button btn" name="apply_coupon" value="<?php _e( 'Go', 'woocommerce' ); ?>" />

                                           </div>
                                           <?php do_action('woocommerce_cart_coupon'); ?>

                                   
                                        </form>
                                    </div>
                                </div>
                               <?php } ?>

                                
                                
                            </div>

                        </div>
                    </div>	
                </section>         
                <!-- End Cart container -->


<?php woocommerce_cross_sell_display(); ?>
<?php do_action( 'woocommerce_after_cart' ); ?>