<?php
echo '<div class="submitbox" id="submitpost">';
$product_categories = get_terms( 'product_cat' );
$condition_types = array(
    'page'          => __('Page', 'BeRocket_products_label_domain'),
    'attribute'     => __('Product Attribute', 'BeRocket_products_label_domain'),
    'search'        => __('Search', 'BeRocket_products_label_domain'),
);
if( is_array($product_categories) && count($product_categories) > 0 ) {
    $condition_types['category'] = __('Product category', 'BeRocket_products_label_domain');
}
$condition_types = apply_filters('berocket_filters_condition_types', $condition_types);
?>
    <div class="">
        <div class="br_filter_group_example" style="display:none;">
            <div class="br_cond_select" data-current="1">
                <span>
                    <select class="br_cond_type">
                        <?php
                        foreach($condition_types as $condition_type_slug => $condition_type_name) {
                            echo '<option value="', $condition_type_slug, '">', $condition_type_name, '</option>';
                        }
                        ?>
                    </select>
                </span>
                <span class="button berocket_remove_condition"><i class="fa fa-minus"></i></span>
                <div class="br_current_cond">
                </div>
            </div>
            <span class="button berocket_add_condition"><i class="fa fa-plus"></i></span>
            <span class="button br_remove_group"><i class="fa fa-minus"></i></span>
        </div>
        <div class="br_cond_example" style="display:none;">
            <?php
            foreach($condition_types as $condition_type_slug => $condition_type_name) {
                $condition_html = apply_filters('berocket_filters_condition_type_' . $condition_type_slug, '', '%name%[data][%id%][%current_id%]', array());
                if( ! empty($condition_html) ) {
                    echo '<div class="br_cond br_cond_', $condition_type_slug, '">
                    ', $condition_html, '
                    <input type="hidden" name="%name%[data][%id%][%current_id%][type]" value="', $condition_type_slug, '">
                    </div>';
                }
            }
            ?>
        </div>
        <div class="br_conditions">
            <?php
            $last_id = 0;
            foreach($filters['data'] as $id => $data) {
                $current_id = 1;
                ob_start();
                foreach($data as $current => $conditions) {
                    if( $current > $current_id ) {
                        $current_id = $current;
                    }
                    ?>
                    <div class="br_cond_select" data-current="<?php echo $current; ?>">
                        <span>
                            <select class="br_cond_type">
                                <?php
                                foreach($condition_types as $condition_type_slug => $condition_type_name) {
                                    echo '<option value="', $condition_type_slug, '"', ( isset($conditions['type']) && $conditions['type'] == $condition_type_slug ? ' selected' : '' ) , '>', $condition_type_name, '</option>';
                                }
                                ?>
                            </select>
                        </span>
                        <span class="button berocket_remove_condition"><i class="fa fa-minus"></i></span>
                        <div class="br_current_cond">
                        </div>
                    <?php 
                    $condition_html = apply_filters('berocket_filters_condition_type_' . $conditions['type'], '', 'BeRocket_product_new_filter[data][' . $id . '][' . $current . ']', $conditions);
                    if( ! empty($condition_html) ) {
                        echo '<div class="br_cond br_cond_', $conditions['type'], '">
                        ', $condition_html, '
                        <input type="hidden" name="BeRocket_product_new_filter[data][' . $id . '][' . $current . '][type]" value="', $conditions['type'], '">
                        </div>';
                    }
                    ?>
                    </div>
                    <?php
                }
                ?>
                <span class="button berocket_add_condition"><i class="fa fa-plus"></i></span>
                <span class="button br_remove_group"><i class="fa fa-minus"></i></span>
                <?php
                $html = ob_get_clean();
                echo '<div class="br_filter_group_condition" data-id="'.$id.'" data-current="'.$current_id.'">';
                echo $html;
                echo '</div>';
                if( $id > $last_id ) {
                    $last_id = $id;
                }
            }
            $last_id++;
            ?>
            <span class="button br_add_group"><i class="fa fa-plus"></i></span>
        </div>
        <script>
            var last_id = <?php echo $last_id; ?>;
            var $html = jQuery('.br_filter_group_example').html();
            $html = '<div class="br_cond_one">'+$html+'</div>';
            jQuery(document).on('change', '.br_cond_type', function(event) {
                var $parent = jQuery(this).parents('.br_cond_select');
                $parent.find('.br_cond').remove();
                var id = $parent.parents('.br_filter_group_condition');
                var current_id = $parent.data('current');
                id = id.data('id');
                var html_need = jQuery('.br_cond_example .br_cond_'+jQuery(this).val()).get(0);
                html_need = html_need.outerHTML;
                html_need = html_need.replace(/%id%/g, id);
                html_need = html_need.replace(/%current_id%/g, current_id);
                html_need = html_need.replace(/%name%/g, 'BeRocket_product_new_filter');
                $parent.find('.br_current_cond').html(html_need);
            });
            jQuery(document).on('click', '.berocket_add_condition', function() {
                var id = jQuery(this).parents('.br_filter_group_condition');
                var current_id = id.data('current');
                current_id = current_id + 1;
                id.data('current', current_id);
                id = id.data('id');
                var $html = jQuery('.br_filter_group_example .br_cond_select').html();
                $html = '<div class="br_cond_select" data-current="'+current_id+'">'+$html+'</div>'; 
                $html = $html.replace('%id%', id);
                jQuery(this).before($html);
                $parent = jQuery(this).prev();
                $parent.find('.br_cond_type').trigger('change');
            });
            jQuery(document).on('click', '.berocket_remove_condition', function() {
                $parent = jQuery(this).parents('.br_cond_select');
                $parent.remove();
            });
            jQuery(document).on('click', '.br_add_group', function() {
                last_id++;
                var html = $html.replace( '%id%', last_id );
                var html = '<div class="br_filter_group_condition" data-id="'+last_id+'" data-current="1">'+html+'</div>';
                jQuery(this).before(html);
                $parent = jQuery(this).prev();
                $parent.find('.br_cond_type').trigger('change');
            });
            jQuery(document).on('click', '.br_remove_group', function() {
                $parent = jQuery(this).parents('.br_filter_group_condition');
                $parent.remove();
            });
            jQuery(document).on('change', '.br_cond_attr_select', function() {
                var $attr_block = jQuery(this).parents('.br_cond_attribute');
                $attr_block.find('.br_attr_values').hide();
                $attr_block.find('.br_attr_value_'+jQuery(this).val()).show();
            });
            jQuery(document).on('change', '.price_from', function() {
                var val_price_from = jQuery(this).val();
                var val_price_to = jQuery(this).parents('.br_cond').first().find('.price_to').val();
                price_from = parseFloat(val_price_from);
                price_to = parseFloat(val_price_to);
                price_to_int = parseInt(val_price_to);
                if( val_price_from == '' ) {
                    jQuery(this).val(0);
                    price_from = 0;
                }
                if( price_from > price_to ) {
                    jQuery(this).val(price_to_int);
                }
            });
            jQuery(document).on('change', '.price_to', function() {
                var val_price_from = jQuery(this).parents('.br_cond').first().find('.price_from').val();
                var val_price_to = jQuery(this).val();
                price_from = parseFloat(val_price_from);
                price_from_int = parseInt(val_price_from);
                price_to = parseFloat(val_price_to);
                if( val_price_to == '' ) {
                    jQuery(this).val(0);
                    price_to = 0;
                }
                if( price_from > price_to ) {
                    jQuery(this).val(price_from_int);
                }
            });
        </script>
        <style>
            .br_conditions .br_filter_group_condition {
                margin-top: 40px;
            }
            .br_conditions .br_filter_group_condition:first-child {
                margin-top: 0;
            }
            .br_conditions .br_filter_group_condition:before {
                content: "OR";
                display: block;
                position: absolute;
                top: -30px;
                font-size: 30px;
            }
            .br_conditions .br_filter_group_condition:first-child:before {
                display: none;
            }
            .br_filter_group_condition .br_cond_select {
                margin-top: 40px;
                position: relative;
            }
            .br_filter_group_condition .br_cond_select:first-child {
                margin-top: 0;
            }
            .br_filter_group_condition .br_cond_select:before {
                content: "AND";
                display: block;
                position: absolute;
                top: -30px;
                font-size: 30px;
            }
            .br_filter_group_condition .br_cond_select:first-child:before {
                display: none;
            }
            .br_filter_group_condition .br_cond_one .br_cond_select:first-child .berocket_remove_condition {
                display: none;
            }
            .br_filter_group_condition {
                border: 1px solid #999;
                background-color: #fafafa;
                padding: 0.5em;
                margin-bottom: 1em;
                position: relative;
            }
            .br_filter_group_condition .br_remove_group {
                position: absolute!important;
                top:-10px;
                right: -10px;
            }
            .br_cond_select {
                padding-bottom: 1em;
            }
            .br_cond_select {
                border: 1px solid #999;
                padding: 0.5em;
                margin-bottom: 0.5em;
                background-color: #eee;
            }
            .br_framework_settings .button.berocket_remove_condition,
            .br_framework_settings .button.berocket_add_condition,
            .br_framework_settings .button.br_remove_group,
            .br_framework_settings .button.br_add_group {
                padding: 0 10px;
                margin: 0;
                width: initial;
                min-width: initial;
            }
            
            .berocket_label_preview_wrap {
                display: inline-block;
                width: 240px;
                padding: 20px;
                background: white;
                position: fixed;
                top: 100%;
                margin-top: -320px;
                min-height: 320px;
                right: 20px;
                box-sizing: border-box;
            }
            .berocket_label_preview_wrap .berocket_label_preview {
                position: relative;
            }
            .berocket_label_preview_wrap .berocket_product_image {
                display: block;
                width: 200px;
            }
            @media screen and (max-width: 850px) {
                .berocket_label_preview_wrap {
                    position: relative;
                }
            }
        </style>
    </div>
    <div>
        <table>
            <tr>
                <th>Hide this group on:</th>
                <td>
                    <label>
                        <input type="checkbox" value="1" name="BeRocket_product_new_filter[is_hide_mobile]"<?php if( ! empty($filters['is_hide_mobile']) ) echo ' checked'; ?>>
                        <?php _e('Mobile', 'BeRocket_AJAX_domain'); ?>
                    </label>
                    <label>
                        <input type="checkbox" value="1" name="BeRocket_product_new_filter[hide_group][tablet]"<?php if( ! empty($filters['hide_group']['tablet']) ) echo ' checked'; ?>>
                        <?php _e('Tablet', 'BeRocket_AJAX_domain'); ?>
                    </label>
                    <label>
                        <input type="checkbox" value="1" name="BeRocket_product_new_filter[hide_group][desktop]"<?php if( ! empty($filters['hide_group']['desktop']) ) echo ' checked'; ?>>
                        <?php _e('Desktop', 'BeRocket_AJAX_domain'); ?>
                    </label>
                </td>
            </tr>
        </table>
    </div>
</div>
