<?php
/*
	Template Name: Blog
*/
?>
<?php get_header(); ?>	
	<div class="container">
	
		<div class="single_left single_full">
		
			<div id="posts_cont">
		
				<?php
				$args = array(
					'category_name' => 'blog',
					 'post_type' => 'post',
					 'posts_per_page' => 6,
					 'paged' => ( get_query_var('paged') ? get_query_var('paged') : 1)
					 );
				query_posts($args);
				$x = 0;
				while (have_posts()) : the_post(); ?>     	
					<div class="blog_box <?php if($x == 2) { echo 'blog_box_last'; } ?>">
						<div class="pad">
							<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('ebox-blog'); ?></a>
						</div>
						<div class="blog_text_cont">
							<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
							<p><?php the_time('F d, Y'); ?></p>
							<p><?php echo ds_get_excerpt(210); ?></p>
						</div>
					</div><!--//blog_box-->
				
				<?php if ($x == 2) { echo '<div class="blog_box clear"></div>'; $x = -1; } $x++; ?>
				<?php endwhile; ?>
				
				<div class="clear"></div>
			
			</div><!--//posts_cont-->
			
			<div class="load_more_cont">
				<div align="center"><div class="load_more_text">
				<?php
				ob_start();
				//next_posts_link('<img src="' . get_bloginfo('stylesheet_directory') . '/images/loading-button.png" />');
				next_posts_link('LOAD MORE POSTS');
				$buffer = ob_get_contents();
				ob_end_clean();
				if(!empty($buffer)) echo $buffer;
				?>
				</div></div>
			</div><!--//load_more_cont-->          			
			
			<?php
			global $wp_query;
			//echo '**' . $wp_query->max_num_pages . '**';	
			$max_pages = $wp_query->max_num_pages;
			?>			
			<div id="max_pages_id" style="display: none;"><?php echo ceil($wp_query->found_posts / 6); //echo $max_pages-1; ?></div>				
		
		</div><!--//single_left-->
		
		<div class="clear"></div>
		
	</div><!--//container-->
		<?php wp_reset_query(); ?> 
<script type="text/javascript">
$(document).ready(
function($){
var curPage = 1;
var pagesNum = $("#max_pages_id").html();   // Number of pages	
if(pagesNum == 1)
	$('.load_more_text a').css('display','none');	
  $('#posts_cont').infinitescroll({
 
    navSelector  : "div.load_more_text",            
		   // selector for the paged navigation (it will be hidden)
    nextSelector : "div.load_more_text a:first",    
		   // selector for the NEXT link (to page 2)
    itemSelector : "#posts_cont .blog_box",
    behavior: "twitter",
    maxPage: <?php echo $max_pages; ?>    
		   // selector for all items you'll retrieve
  },function(arrayOfNewElems){
  
  $('#posts_cont').append('<div class="clear"></div>');
      //$('.home_post_cont img').hover_caption();
      $('.load_more_text a').css('visibility','visible');
            curPage++;
//            alert(curPage + '**' + pagesNum);
            if(curPage == pagesNum) {
                //$(window).unbind('.infscr');
                $('.load_more_text a').css('display','none');
            } else {}  	    
  
      //$('.home_post_cont img').hover_caption();
 
     // optional callback when new content is successfully loaded in.
 
     // keyword `this` will refer to the new DOM content that was just added.
     // as of 1.5, `this` matches the element you called the plugin on (e.g. #content)
     //                   all the new elements that were found are passed in as an array
 
  });  
}  
);
</script>	
<?php get_footer(); ?> 		